﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using DayOfWeek = PpmsDataService.ModelsEnumTypes.DayOfWeek;

namespace PpmsDataService.V1.Mappers
{
    public class ServiceAvailabilityMap
    {
        public static async Task<IQueryable<ServiceAvailability>> MapServiceAvailabilities(List<ppms_serviceavailability> ppmsServiceAvailabilities, string mapRelatedType, PpmsContext context)
        {
            var serviceAvailabilities = new List<ServiceAvailability> { };
            foreach (var ppmsServiceAvailability in ppmsServiceAvailabilities)
            {
                var serviceAvailability = new ServiceAvailability
                {
                   Name = ppmsServiceAvailability.ppms_name,
                   StartTime = ppmsServiceAvailability.ppms_starttime,
                   EndTime = ppmsServiceAvailability.ppms_endtime
                };

                //Day of Week Switch
                if (ppmsServiceAvailability.ppms_dayofweek != null)
                    switch (ppmsServiceAvailability.ppms_dayofweek.Value)
                    {
                        case (int)new_DayOfWeek.Monday:
                            serviceAvailability.DayOfWeek = DayOfWeek.Monday;
                            break;
                        case (int)new_DayOfWeek.Tuesday:
                            serviceAvailability.DayOfWeek = DayOfWeek.Tuesday;
                            break;
                        case (int)new_DayOfWeek.Wednesday:
                            serviceAvailability.DayOfWeek = DayOfWeek.Wednesday;
                            break;
                        case (int)new_DayOfWeek.Thursday:
                            serviceAvailability.DayOfWeek = DayOfWeek.Thursday;
                            break;
                        case (int)new_DayOfWeek.Friday:
                            serviceAvailability.DayOfWeek = DayOfWeek.Friday;
                            break;
                        case (int)new_DayOfWeek.Saturday:
                            serviceAvailability.DayOfWeek = DayOfWeek.Saturday;
                            break;
                        case (int)new_DayOfWeek.Sunday:
                            serviceAvailability.DayOfWeek = DayOfWeek.Sunday;
                            break;
                        default:
                            break;
                    }
                serviceAvailabilities.Add(serviceAvailability);
            }
            return serviceAvailabilities.AsQueryable();
        }      
    }
}